package com.github.gigiosouza.japigeebundler.apigee.flows.targetendpoint;

import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import com.github.gigiosouza.japigeebundler.apigee.flows.FaultRule;
import com.github.gigiosouza.japigeebundler.apigee.flows.Flow;
import lombok.Data;

import java.util.*;

@Data
@JacksonXmlRootElement(localName = "TargetEndpoint")
@JsonPropertyOrder({
  "preFlow",
  "flows",
  "postFlow",
  "faultRules",
  "defaultFaultRule",
  "localTargetConnection",
  "httpTargetConnection",
  "scriptTarget"
})
public class TargetEndpoint {

  @JacksonXmlProperty(isAttribute = true, localName = "name")
  private String name;

  @JacksonXmlProperty(localName = "PreFlow")
  private Flow preFlow = new Flow("PreFlow");

  @JacksonXmlElementWrapper(localName = "Flows")
  @JacksonXmlProperty(localName = "Flow")
  private Set<Flow> flows = new LinkedHashSet<>();

  @JacksonXmlProperty(localName = "PostFlow")
  private Flow postFlow = new Flow("PostFlow");

  @JacksonXmlProperty(localName = "DefaultFaultRule")
  private FaultRule defaultFaultRule;

  @JacksonXmlElementWrapper(localName = "FaultRules")
  @JacksonXmlProperty(localName = "FaultRule")
  private Set<FaultRule> faultRules = new LinkedHashSet<>();;

  @JacksonXmlProperty(localName = "HTTPTargetConnection")
  private HTTPTargetConnection httpTargetConnection;

  @JacksonXmlProperty(localName = "LocalTargetConnection")
  private LocalTargetConnection localTargetConnection;

  @JacksonXmlProperty(localName = "ScriptTarget")
  private ScriptTarget scriptTarget;

  public void prependFlows(final Flow... flows) {
    LinkedHashSet<Flow> newFlows = new LinkedHashSet<>();
    newFlows.addAll(Arrays.asList(flows));
    newFlows.addAll(this.flows);
    this.flows = newFlows;
  }

  public void appendFlows(final Flow... flows) {
    this.flows.addAll(Arrays.asList(flows));
  }

  public void prependFaultRules(final FaultRule... faultRules) {
    LinkedHashSet<FaultRule> newFaultRules = new LinkedHashSet<>();
    newFaultRules.addAll(Arrays.asList(faultRules));
    newFaultRules.addAll(this.faultRules);
    this.faultRules = newFaultRules;
  }

  public void appendFaultRules(final FaultRule... faultRules) {
    this.faultRules.addAll(Arrays.asList(faultRules));
  }

}
