package com.github.gigiosouza.japigeebundler.apigee.policies.extension;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import com.github.gigiosouza.japigeebundler.apigee.commons.NamedValueRef;
import com.github.gigiosouza.japigeebundler.apigee.policies.Policy;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import lombok.Data;

import java.util.List;

@Data
@JacksonXmlRootElement(localName = "FlowCallout")
public class FlowCalloutPolicy extends Policy {

  @NotEmpty
  @NotNull
  @JacksonXmlProperty(localName = "SharedFlowBundle")
  private String sharedFlowBundle;

  @JacksonXmlElementWrapper(localName = "Parameters")
  @JacksonXmlProperty(localName = "Parameter")
  private List<NamedValueRef<String>> parameters;

  @Override
  public void defaultValues() {
    this.defaultHeader();
  }

}
