package com.github.gigiosouza.japigeebundler.apigee.policies.extension;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import com.github.gigiosouza.japigeebundler.apigee.policies.Policy;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import lombok.Data;

@Data
@JacksonXmlRootElement(localName = "JavaCallout")
public class JavaCalloutPolicy extends Policy {

  @NotEmpty
  @NotNull
  @JacksonXmlProperty(localName = "ClassName")
  private String className;

  @NotEmpty
  @NotNull
  @JacksonXmlProperty(localName = "ResourceURL")
  private String resourceURL;

  @Override
  public void defaultValues() {
    this.defaultHeader();
  }

}
