package com.github.gigiosouza.japigeebundler.apigee.policies.extension;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import com.github.gigiosouza.japigeebundler.apigee.policies.Policy;
import com.github.gigiosouza.japigeebundler.apigee.flows.targetendpoint.SSLInfo;
import lombok.Data;

@Data
@JacksonXmlRootElement(localName = "Javascript")
public class JavaScriptPolicy extends Policy {

  @JacksonXmlProperty(localName = "IncludeURL")
  private String includeURL;

  @JacksonXmlProperty(localName = "ResourceURL")
  private String resourceURL;

  @JacksonXmlProperty(localName = "SSLInfo")
  private SSLInfo sslInfo;

  @Override
  public void defaultValues() {
    this.defaultHeader();
  }

}
