package com.github.gigiosouza.japigeebundler.apigee.policies.extension.extensioncallout;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import com.github.gigiosouza.japigeebundler.apigee.policies.Policy;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import lombok.Data;

@Data
@JacksonXmlRootElement(localName = "ConnectorCallout")
public class ExtensionCalloutPolicy extends Policy {

  @NotEmpty
  @NotNull
  @JacksonXmlProperty(localName = "Connector")
  private String connector;

  @NotEmpty
  @NotNull
  @JacksonXmlProperty(localName = "Action")
  private String action;

  @JacksonXmlProperty(localName = "Input")
  private String input;

  @JacksonXmlProperty(localName = "Output")
  private Output output;

  @Override
  public void defaultValues() {
    this.defaultHeader();
  }

}
