package com.github.gigiosouza.japigeebundler.apigee.policies.extension.messagelogging;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@AllArgsConstructor
@NoArgsConstructor
public class FileRotationOptions {

  @JacksonXmlProperty(isAttribute = true, localName = "rotateFileOnStartup")
  private Boolean rotateFileOnStartup;

  @JacksonXmlProperty(localName = "FileRotationType")
  private FileRotationType FileRotationType;

  @JacksonXmlProperty(localName = "MaxFileSizeInMB")
  private Integer maxFileSizeInMB;

  @JacksonXmlProperty(localName = "RotationFrequency")
  private RotationFrequency rotationFrequency;

  @JacksonXmlProperty(localName = "MaxFilesToRetain")
  private Integer maxFilesToRetain;

}
