package com.github.gigiosouza.japigeebundler.apigee.policies.extension.messagelogging;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.github.gigiosouza.japigeebundler.apigee.flows.targetendpoint.SSLInfo;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@AllArgsConstructor
@NoArgsConstructor
public class Syslog {

  @JacksonXmlProperty(localName = "Message")
  private String message;

  @JacksonXmlProperty(localName = "Host")
  private String host; // default: localhost

  @JacksonXmlProperty(localName = "Port")
  private Integer port; // default: 514

  @JacksonXmlProperty(localName = "Protocol")
  private SyslogProtocol protocol; // default: UDP

  @JacksonXmlProperty(localName = "FormatMessage")
  private Boolean formatMessage; // default: false

  @JacksonXmlProperty(localName = "PayloadOnly")
  private Boolean payloadOnly; // default: false

  @JacksonXmlProperty(localName = "SSLInfo")
  private SSLInfo sslInfo;

}
