package com.github.gigiosouza.japigeebundler.apigee.policies.extension.servicecallout;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.github.gigiosouza.japigeebundler.apigee.policies.mediation.assignmessage.Add;
import com.github.gigiosouza.japigeebundler.apigee.policies.mediation.assignmessage.Copy;
import com.github.gigiosouza.japigeebundler.apigee.policies.mediation.assignmessage.Remove;
import com.github.gigiosouza.japigeebundler.apigee.policies.mediation.assignmessage.Set;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@AllArgsConstructor
@NoArgsConstructor
public class Request {

  @JacksonXmlProperty(isAttribute = true, localName = "clearPayload")
  private Boolean clearPayload;

  @JacksonXmlProperty(isAttribute = true, localName = "variable")
  private String variable;

  @JacksonXmlProperty(localName = "Add")
  private Add add;

  @JacksonXmlProperty(localName = "Set")
  private Set set;

  @JacksonXmlProperty(localName = "Copy")
  private Copy copy;

  @JacksonXmlProperty(localName = "Remove")
  private Remove remove;

  @JacksonXmlProperty(localName = "IgnoreUnresolvedVariables")
  private Boolean ignoreUnresolvedVariables;

}
