package com.github.gigiosouza.japigeebundler.apigee.policies.extension.servicecallout;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import com.github.gigiosouza.japigeebundler.apigee.policies.Policy;
import com.github.gigiosouza.japigeebundler.apigee.flows.targetendpoint.HTTPTargetConnection;
import com.github.gigiosouza.japigeebundler.apigee.flows.targetendpoint.LocalTargetConnection;
import lombok.Data;

@Data
@JacksonXmlRootElement(localName = "ServiceCallout")
public class ServiceCalloutPolicy extends Policy {

  @JacksonXmlProperty(localName = "Request")
  private Request request;

  @JacksonXmlProperty(localName = "Response")
  private String response;

  @JacksonXmlProperty(localName = "Timeout")
  private Integer timeout;

  @JacksonXmlProperty(localName = "HTTPTargetConnection")
  private HTTPTargetConnection httpTargetConnection;

  @JacksonXmlProperty(localName = "LocalTargetConnection")
  private LocalTargetConnection localTargetConnection;

  @Override
  public void defaultValues() {
    this.defaultHeader();
    this.timeout = 55000;
  }

}
