package com.github.gigiosouza.japigeebundler.apigee.policies.extension.statisticcollector;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlText;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@AllArgsConstructor
@NoArgsConstructor
public class Statistic {

  @NotEmpty
  @NotNull
  @JacksonXmlProperty(isAttribute = true, localName = "name")
  private String name;

  @NotEmpty
  @NotNull
  @JacksonXmlProperty(isAttribute = true, localName = "ref")
  private String ref;

  @JacksonXmlProperty(isAttribute = true, localName = "type")
  private String type; // string/integer/float/long/double/boolean

  @JacksonXmlText
  private String value;

}
