package com.github.gigiosouza.japigeebundler.apigee.policies.mediation.accessentity;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import com.github.gigiosouza.japigeebundler.apigee.policies.Policy;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import lombok.Data;

import java.util.List;
import java.util.Set;

@Data
@JacksonXmlRootElement(localName = "AccessEntity")
public class AccessEntityPolicy extends Policy {

  @Valid
  @JacksonXmlProperty(localName = "EntityIdentifier")
  private EntityIdentifier entityIdentifier;

  @Valid
  @NotNull
  @JacksonXmlProperty(localName = "EntityType")
  private EntityType entityType;

  @Valid
  @JacksonXmlProperty(localName = "SecondaryIdentifier")
  private EntityIdentifier secondaryIdentifier;

  @Valid
  @JacksonXmlElementWrapper(localName = "Identifiers")
  @JacksonXmlProperty(localName = "Identifier")
  private List<Identifier> identifiers;

  @Override
  public void defaultValues() {
    this.defaultHeader();
  }

  @Override
  protected Set<String> customValidation() {
    // entityIdentifier or identifiers must not be null
    return null;
  }
}
