package com.github.gigiosouza.japigeebundler.apigee.policies.mediation.accessentity;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@AllArgsConstructor
@NoArgsConstructor
public class EntityIdentifier {

  @NotEmpty
  @NotNull
  @JacksonXmlProperty(isAttribute = true, localName = "ref")
  private String ref;

  @NotEmpty
  @NotNull
  @JacksonXmlProperty(isAttribute = true, localName = "type")
  private String type;

}
