package com.github.gigiosouza.japigeebundler.apigee.policies.mediation.assignmessage;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import com.github.gigiosouza.japigeebundler.apigee.policies.Policy;
import lombok.Data;

import java.util.List;

@Data
@JacksonXmlRootElement(localName = "AssignMessage")
public class AssignMessagePolicy extends Policy {

  @JacksonXmlProperty(localName = "IgnoreUnresolvedVariables")
  private Boolean ignoreUnresolvedVariables;

  @JacksonXmlProperty(localName = "AssignTo")
  private AssignTo assignTo;

  @JacksonXmlElementWrapper(useWrapping = false)
  @JacksonXmlProperty(localName = "AssignVariable")
  private List<AssignVariable> assignVariables;

  @JacksonXmlProperty(localName = "Add")
  private Add add;

  @JacksonXmlProperty(localName = "Set")
  private Set set;

  @JacksonXmlProperty(localName = "Copy")
  private Copy copy;

  @JacksonXmlProperty(localName = "Remove")
  private Remove remove;

  @Override
  public void defaultValues() {
    this.defaultHeader();
    this.ignoreUnresolvedVariables = true;
  }

}
