package com.github.gigiosouza.japigeebundler.apigee.policies.mediation.assignmessage;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.github.gigiosouza.japigeebundler.apigee.commons.NameValue;
import jakarta.validation.Valid;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

@Data
@AllArgsConstructor
@NoArgsConstructor
public class Copy {

  @JacksonXmlProperty(isAttribute = true, localName = "source")
  private String source;

  @JacksonXmlProperty(localName = "Path")
  private String path;

  @JacksonXmlProperty(localName = "Payload")
  private String payload;

  @JacksonXmlProperty(localName = "ReasonPhrase")
  private String reasonPhrase;

  @JacksonXmlProperty(localName = "StatusCode")
  private String statusCode;

  @JacksonXmlProperty(localName = "Verb")
  private String verb;

  @JacksonXmlProperty(localName = "Version")
  private String version;

  @Valid
  @JacksonXmlProperty(localName = "Header")
  @JacksonXmlElementWrapper(localName = "Headers")
  private List<NameValue> headers;

  @Valid
  @JacksonXmlProperty(localName = "FormParam")
  @JacksonXmlElementWrapper(localName = "FormParams")
  private List<NameValue> formParams;

  @Valid
  @JacksonXmlProperty(localName = "QueryParam")
  @JacksonXmlElementWrapper(localName = "QueryParams")
  private List<NameValue> queryParams;

}
