package com.github.gigiosouza.japigeebundler.apigee.policies.mediation.assignmessage;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.github.gigiosouza.japigeebundler.apigee.commons.NameValue;
import jakarta.validation.Valid;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

@Data
@AllArgsConstructor
@NoArgsConstructor
public class Remove {

  @JacksonXmlProperty(localName = "Payload")
  private String payload;

  @Valid
  @JacksonXmlProperty(localName = "Header")
  @JacksonXmlElementWrapper(localName = "Headers")
  private List<NameValue> headers;

  @Valid
  @JacksonXmlProperty(localName = "FormParam")
  @JacksonXmlElementWrapper(localName = "FormParams")
  private List<NameValue> formParams;

  @Valid
  @JacksonXmlProperty(localName = "QueryParam")
  @JacksonXmlElementWrapper(localName = "QueryParams")
  private List<NameValue> queryParams;

  // values must not be null

}
