package com.github.gigiosouza.japigeebundler.apigee.policies.mediation.extractvariables;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import com.github.gigiosouza.japigeebundler.apigee.policies.Policy;
import lombok.Data;

import java.util.List;

@Data
@JacksonXmlRootElement(localName = "ExtractVariables")
public class ExtractVariablesPolicy extends Policy {

  @JacksonXmlProperty(localName = "Source")
  private Source source;

  @JacksonXmlProperty(localName = "VariablePrefix")
  private String variablePrefix;

  @JacksonXmlProperty(localName = "IgnoreUnresolvedVariables")
  private Boolean ignoreUnresolvedVariables;

  @JacksonXmlElementWrapper(localName = "URIPath")
  @JacksonXmlProperty(localName = "Pattern")
  private List<Pattern> uriPaths;

  @JacksonXmlElementWrapper(useWrapping = false)
  @JacksonXmlProperty(localName = "QueryParam")
  private List<NamedPattern> queryParams;

  @JacksonXmlElementWrapper(useWrapping = false)
  @JacksonXmlProperty(localName = "Header")
  private List<NamedPattern> headers;

  @JacksonXmlElementWrapper(useWrapping = false)
  @JacksonXmlProperty(localName = "FormParam")
  private List<NamedPattern> formParams;

  @JacksonXmlElementWrapper(useWrapping = false)
  @JacksonXmlProperty(localName = "Variable")
  private List<NamedPattern> variables;

  @JacksonXmlProperty(localName = "JSONPayload")
  private JSONPayload jsonPayload;

  @JacksonXmlProperty(localName = "XMLPayload")
  private XMLPayload xmlPayload;

  @Override
  public void defaultValues() {
    this.defaultHeader();
    this.ignoreUnresolvedVariables = true;
  }

  // must have at least one of them fulfilled <URIPath>, <QueryParam>, <Header>, <FormParam>, <JSONPayload>, or <XMLPayload>
  // must validate Variables types: string, boolean, integer, long, float, double, nodeset

}
