package com.github.gigiosouza.japigeebundler.apigee.policies.mediation.extractvariables;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@AllArgsConstructor
@NoArgsConstructor
public class JSONVariable {

  @NotEmpty
  @NotNull
  @JacksonXmlProperty(isAttribute = true, localName = "name")
  private String name;

  @JacksonXmlProperty(isAttribute = true, localName = "type")
  private String type;

  @JacksonXmlProperty(localName = "JSONPath")
  private String jsonPath;

}
