package com.github.gigiosouza.japigeebundler.apigee.policies.mediation.extractvariables;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.github.gigiosouza.japigeebundler.apigee.commons.xml.Namespace;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

@Data
@AllArgsConstructor
@NoArgsConstructor
public class XMLPayload {

  @JacksonXmlProperty(isAttribute = true, localName = "stopPayloadProcessing")
  private Boolean stopPayloadProcessing;

  @JacksonXmlElementWrapper(localName = "Namespaces")
  @JacksonXmlProperty(localName = "Namespace")
  private List<Namespace> namespaces;

  @JacksonXmlElementWrapper(useWrapping = false)
  @JacksonXmlProperty(localName = "Variable")
  private List<XMLVariable> variables;

}
