package com.github.gigiosouza.japigeebundler.apigee.policies.mediation.jsontoxml;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import com.github.gigiosouza.japigeebundler.apigee.policies.Policy;
import lombok.Data;

@Data
@JacksonXmlRootElement(localName = "JSONtoXML")
public class JSONtoXMLPolicy extends Policy {

  @JacksonXmlProperty(localName = "Source")
  private String source;

  @JacksonXmlProperty(localName = "OutputVariable")
  private String outputVariable;

  @JacksonXmlProperty(localName = "Options")
  private Options options;

  @Override
  public void defaultValues() {
    this.defaultHeader();
  }

}
