package com.github.gigiosouza.japigeebundler.apigee.policies.mediation.kvm;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import com.github.gigiosouza.japigeebundler.apigee.policies.Policy;
import lombok.Data;

import java.util.List;

@Data
@JacksonXmlRootElement(localName = "KeyValueMapOperations")
public class KeyValueMapOperationsPolicy extends Policy {

  @JacksonXmlProperty(isAttribute = true, localName = "mapIdentifier")
  private String mapIdentifier;

  @JacksonXmlProperty(localName = "Scope")
  private KVMScope scope;

  @JacksonXmlProperty(localName = "ExclusiveCache")
  private String exclusiveCache;

  @JacksonXmlProperty(localName = "ExpiryTimeInSecs")
  private String expiryTimeInSecs;

  @JacksonXmlElementWrapper(localName = "InitialEntries")
  @JacksonXmlProperty(localName = "Entry")
  private List<Entry> initialEntries;

  @JacksonXmlElementWrapper(useWrapping = false)
  @JacksonXmlProperty(localName = "Delete")
  private List<Delete> delete;

  @JacksonXmlElementWrapper(useWrapping = false)
  @JacksonXmlProperty(localName = "Put")
  private List<Put> puts;

  @JacksonXmlElementWrapper(useWrapping = false)
  @JacksonXmlProperty(localName = "Get")
  private List<Get> gets;

  @Override
  public void defaultValues() {
    this.defaultHeader();
    this.expiryTimeInSecs = "300";
    this.scope = KVMScope.environment;
  }

  // must have at least one of <Delete>, <Get> or <Put>

}
