package com.github.gigiosouza.japigeebundler.apigee.policies.mediation.kvm;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.github.gigiosouza.japigeebundler.apigee.commons.ValueRef;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

@Data
@AllArgsConstructor
@NoArgsConstructor
public class Put {

  @JacksonXmlProperty(isAttribute = true, localName = "override")
  private Boolean override;

  @JacksonXmlProperty(localName = "Key")
  private Key key;

  @JacksonXmlElementWrapper(useWrapping = false)
  @JacksonXmlProperty(localName = "Value")
  private List<ValueRef<String>> value;

}
