package com.github.gigiosouza.japigeebundler.apigee.policies.mediation.oasvalidation;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import com.github.gigiosouza.japigeebundler.apigee.policies.Policy;
import lombok.Data;

@Data
@JacksonXmlRootElement(localName = "OASValidation")
public class OASValidationPolicy extends Policy {

  @JacksonXmlProperty(localName = "OASResource")
  private String oasResource; // must have suffix .json, .yml, .yaml

  @JacksonXmlProperty(localName = "Options")
  private Options options;

  @JacksonXmlProperty(localName = "Source")
  private String source; // message, request, response

  @Override
  public void defaultValues() {
    this.defaultHeader();
    this.source = "request";
  }

}
