package com.github.gigiosouza.japigeebundler.apigee.policies.mediation.raisefault;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.github.gigiosouza.japigeebundler.apigee.commons.NameValue;
import com.github.gigiosouza.japigeebundler.apigee.policies.mediation.assignmessage.Payload;
import jakarta.validation.Valid;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

@Data
@AllArgsConstructor
@NoArgsConstructor
public class FaultResponseSet {

  @JacksonXmlProperty(localName = "Payload")
  private Payload payload;

  @JacksonXmlProperty(localName = "ReasonPhrase")
  private String reasonPhrase;

  @JacksonXmlProperty(localName = "StatusCode")
  private Integer statusCode;

  @Valid
  @JacksonXmlProperty(localName = "Header")
  @JacksonXmlElementWrapper(localName = "Headers")
  private List<NameValue> headers;

}
