package com.github.gigiosouza.japigeebundler.apigee.policies.mediation.raisefault;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import com.github.gigiosouza.japigeebundler.apigee.policies.Policy;
import lombok.Data;

@Data
@JacksonXmlRootElement(localName = "RaiseFault")
public class RaiseFaultPolicy extends Policy {

  @JacksonXmlProperty(localName = "IgnoreUnresolvedVariables")
  private String ignoreUnresolvedVariables;

  @JacksonXmlProperty(localName = "FaultResponse")
  private FaultResponse faultResponse;

  @JacksonXmlProperty(localName = "ShortFaultReason")
  private String shortFaultReason;

  @Override
  public void defaultValues() {
    this.defaultHeader();
    this.ignoreUnresolvedVariables = "true";
    this.shortFaultReason = "false";
  }

}
