package com.github.gigiosouza.japigeebundler.apigee.policies.mediation.soapmessagevalidation;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import com.github.gigiosouza.japigeebundler.apigee.policies.Policy;
import lombok.Data;

import java.util.List;

@Data
@JacksonXmlRootElement(localName = "SOAPMessageValidation")
public class SOAPMessageValidationPolicy extends Policy {

  @JacksonXmlElementWrapper(useWrapping = false)
  @JacksonXmlProperty(localName = "Element")
  private List<Element> elements;

  @JacksonXmlProperty(localName = "SOAPMessage")
  private SOAPMessage soapMessage;

  @JacksonXmlProperty(localName = "Source")
  private String source;

  @JacksonXmlProperty(localName = "ResourceURL")
  private String resourceURL;

  @Override
  public void defaultValues() {
    this.defaultHeader();
    this.source = "request";
  }

}
