package com.github.gigiosouza.japigeebundler.apigee.policies.mediation.xlstransform;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import com.github.gigiosouza.japigeebundler.apigee.policies.Policy;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import lombok.Data;

@Data
@JacksonXmlRootElement(localName = "XLS")
public class XLSTransformPolicy extends Policy {

  @JacksonXmlProperty(localName = "Source")
  private String source;

  @NotEmpty
  @NotNull
  @JacksonXmlProperty(localName = "ResourceURL")
  private String resourceURL;

  @JacksonXmlProperty(localName = "OutputVariable")
  private String outputVariable;

  @JacksonXmlProperty(localName = "Parameters")
  private Parameters parameters;

  @Override
  public void defaultValues() {
    this.defaultHeader();
  }
}
