package com.github.gigiosouza.japigeebundler.apigee.policies.mediation.xmltojson;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import lombok.Data;

import java.util.List;

@Data
public class Options {

  @JacksonXmlProperty(localName = "DefaultNamespaceNodeName")
  private String defaultNamespaceNodeName;

  @JacksonXmlProperty(localName = "NamespaceSeparator")
  private String namespaceSeparator;

  @JacksonXmlProperty(localName = "AttributeBlockName")
  private String attributeBlockName;

  @JacksonXmlProperty(localName = "AttributePrefix")
  private String attributePrefix;

  @JacksonXmlProperty(localName = "NullValue")
  private String nullValue;

  @JacksonXmlProperty(localName = "TextNodeName")
  private String textNodeName;

  @JacksonXmlProperty(localName = "RecognizeNumber")
  private String recognizeNumber;

  @JacksonXmlProperty(localName = "RecognizeBoolean")
  private String recognizeBoolean;

  @JacksonXmlProperty(localName = "RecognizeNull")
  private String recognizeNull;

  @JacksonXmlProperty(localName = "NamespaceBlockName")
  private String namespaceBlockName;

  @JacksonXmlProperty(localName = "TextAlwaysAsProperty")
  private String textAlwaysAsProperty;

  @JacksonXmlProperty(localName = "OutputPrefix")
  private String outputPrefix;

  @JacksonXmlProperty(localName = "OutputSuffix")
  private String outputSuffix;

  @JacksonXmlProperty(localName = "StripLevels")
  private String stripLevels;

  @JacksonXmlElementWrapper(localName = "TreatAsArray")
  @JacksonXmlProperty(localName = "Path")
  private List<Path> treatAsArray;

}
