package com.github.gigiosouza.japigeebundler.apigee.policies.mediation.xmltojson;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import com.github.gigiosouza.japigeebundler.apigee.policies.Policy;
import lombok.Data;

@Data
@JacksonXmlRootElement(localName = "XMLtoJSON")
public class XMLtoJSONPolicy extends Policy {

  @JacksonXmlProperty(localName = "Source")
  private String source;

  @JacksonXmlProperty(localName = "OutputVariable")
  private String outputVariable;

  @JacksonXmlProperty(localName = "Format")
  private String format; // xml.com, yahoo, google, badgerFish
  // one /\ or another \/ never both
  @JacksonXmlProperty(localName = "Options")
  private Options options;

  @Override
  public void defaultValues() {
    this.defaultHeader();
  }

}
