package com.github.gigiosouza.japigeebundler.apigee.policies.security;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import com.github.gigiosouza.japigeebundler.apigee.policies.Policy;
import lombok.Data;

@Data
@JacksonXmlRootElement(localName = "JSONThreatProtection")
public class JSONThreatProtectionPolicy extends Policy {

  @JacksonXmlProperty(localName = "ArrayElementCount")
  private String arrayElementCount;

  @JacksonXmlProperty(localName = "ContainerDepth")
  private String containerDepth;

  @JacksonXmlProperty(localName = "ObjectEntryCount")
  private String objectEntryCount;

  @JacksonXmlProperty(localName = "ObjectEntryNameLength")
  private String objectEntryNameLength;

  @JacksonXmlProperty(localName = "Source")
  private String source;

  @JacksonXmlProperty(localName = "StringValueLength")
  private String stringValueLength;

  @Override
  public void defaultValues() {
    this.defaultHeader();
    this.source = "request";
  }
}
