package com.github.gigiosouza.japigeebundler.apigee.policies.security;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import com.github.gigiosouza.japigeebundler.apigee.policies.Policy;
import com.github.gigiosouza.japigeebundler.apigee.commons.Ref;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import lombok.Data;

@Data
@JacksonXmlRootElement(localName = "VerifyAPIKey")
public class VerifyAPIKeyPolicy extends Policy {

  @NotEmpty
  @NotNull
  @JacksonXmlProperty(localName = "APIKey")
  private Ref apiKey;

  @Override
  public void defaultValues() {
    this.defaultHeader();
  }
}
