package com.github.gigiosouza.japigeebundler.apigee.policies.security.accesscontrol;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import com.github.gigiosouza.japigeebundler.apigee.policies.Policy;
import lombok.Data;

@Data
@JacksonXmlRootElement(localName = "AccessControl")
public class AccessControlPolicy extends Policy {

  @JacksonXmlProperty(localName = "IgnoreTrueClientIPHeader")
  private String ignoreTrueClientIPHeader;

  @JacksonXmlProperty(localName = "IPRules")
  private IPRules ipRules;

  @JacksonXmlProperty(localName = "ValidateBasedOn")
  private String validateBasedOn; // X_FORWARDED_FOR_ALL_IP, X_FORWARDED_FOR_FIRST_IP, X_FORWARDED_FOR_LAST_IP

  @Override
  public void defaultValues() {
    this.defaultHeader();
    this.ignoreTrueClientIPHeader = "true";
    this.validateBasedOn = "X_FORWARDED_FOR_ALL_IP";
  }
}
