package com.github.gigiosouza.japigeebundler.apigee.policies.security.accesscontrol;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

@Data
@AllArgsConstructor
@NoArgsConstructor
public class MatchRule {

  @NotEmpty
  @NotNull
  @JacksonXmlProperty(isAttribute = true, localName = "action")
  private IPRuleAction action;

  @JacksonXmlElementWrapper(useWrapping = false)
  @JacksonXmlProperty(localName = "SourceAddress")
  private List<SourceAddress> sourceAddresses;

}
