package com.github.gigiosouza.japigeebundler.apigee.policies.security.accesscontrol;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlText;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@AllArgsConstructor
@NoArgsConstructor
public class SourceAddress {

  @NotEmpty
  @NotNull
  @JacksonXmlProperty(isAttribute = true, localName = "mask")
  private String mask;

  @JacksonXmlText
  private String value;

}
