package com.github.gigiosouza.japigeebundler.apigee.policies.security.basicauth;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import com.github.gigiosouza.japigeebundler.apigee.policies.Policy;
import com.github.gigiosouza.japigeebundler.apigee.commons.Ref;
import lombok.Data;

@Data
@JacksonXmlRootElement(localName = "BasicAuthentication")
public class BasicAuthenticationPolicy extends Policy {

  @JacksonXmlProperty(localName = "Operation")
  private BasicAuthOperation operation;

  @JacksonXmlProperty(localName = "IgnoreUnresolvedVariables")
  private Boolean ignoreUnresolvedVariables;

  @JacksonXmlProperty(localName = "User")
  private Ref user;

  @JacksonXmlProperty(localName = "Password")
  private Ref password;

  @JacksonXmlProperty(localName = "AssignTo")
  private AssignTo assignTo;

  @JacksonXmlProperty(localName = "Source")
  private String source;

  @Override
  public void defaultValues() {
    this.defaultHeader();
    this.ignoreUnresolvedVariables = true;
  }
}
