package com.github.gigiosouza.japigeebundler.apigee.policies.security.jwx;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlText;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@AllArgsConstructor
@NoArgsConstructor
public class Claim {

  @NotEmpty
  @NotNull
  @JacksonXmlProperty(isAttribute = true, localName = "name")
  private String name;

  @JacksonXmlProperty(isAttribute = true, localName = "ref")
  private String ref;

  @JacksonXmlProperty(isAttribute = true, localName = "type")
  private String type; // string, number, boolean, or map

  @JacksonXmlProperty(isAttribute = true, localName = "array")
  private Boolean array;

  @JacksonXmlText
  private String value;

}
