package com.github.gigiosouza.japigeebundler.apigee.policies.security.jwx;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import com.github.gigiosouza.japigeebundler.apigee.policies.Policy;
import lombok.Data;

@Data
@JacksonXmlRootElement(localName = "DecodeJWT")
public class DecodeJWTPolicy extends Policy {

  @JacksonXmlProperty(localName = "Source")
  private String source;

  @Override
  public void defaultValues() {
    this.defaultHeader();
    this.source = "request.header.authorization";
  }
}
