package com.github.gigiosouza.japigeebundler.apigee.policies.security.jwx;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import com.github.gigiosouza.japigeebundler.apigee.policies.Policy;
import com.github.gigiosouza.japigeebundler.apigee.commons.ValueRef;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import lombok.Data;

import java.util.List;

@Data
@JacksonXmlRootElement(localName = "GenerateJWS")
public class GenerateJWSPolicy extends Policy {

  @NotEmpty
  @NotNull
  @JacksonXmlProperty(localName = "Algorithm")
  private String algorithm; // HS256, HS384, HS512, RS256, RS384, RS512, ES256, ES384, ES512, PS256, PS384, PS512

  @JacksonXmlProperty(localName = "IgnoreUnresolvedVariables")
  private Boolean ignoreUnresolvedVariables;

  @JacksonXmlElementWrapper(localName = "AdditionalHeaders")
  @JacksonXmlProperty(localName = "Claim")
  private List<Claim> additionalHeaders;

  @JacksonXmlProperty(localName = "CriticalHeaders")
  private ValueRef<String> criticalHeaders;

  @JacksonXmlProperty(localName = "DetachContent")
  private Boolean detachContent;

  @JacksonXmlProperty(localName = "OutputVariable")
  private String outputVariable;

  @JacksonXmlProperty(localName = "Payload")
  private ValueRef<String> payload;

  @JacksonXmlProperty(localName = "PrivateKey")
  private PrivateKey privateKey; // Use only when the algorithm is one of RS256/RS384/RS512, PS256/PS384/PS512, or ES256/ES384/ES512.

  @JacksonXmlProperty(localName = "SecretKey")
  private SecretKey secretKey; // Use only when the algorithm is one of HS256/HS384/HS512.

  @Override
  public void defaultValues() {
    this.defaultHeader();
    this.ignoreUnresolvedVariables = false;
    this.detachContent = false;
  }

}
