package com.github.gigiosouza.japigeebundler.apigee.policies.security.jwx;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import com.github.gigiosouza.japigeebundler.apigee.policies.Policy;
import com.github.gigiosouza.japigeebundler.apigee.commons.ValueRef;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import lombok.Data;

import java.util.List;

@Data
@JacksonXmlRootElement(localName = "GenerateJWT")
public class GenerateJWTPolicy extends Policy {

  @NotEmpty
  @NotNull
  @JacksonXmlProperty(localName = "Algorithm")
  private String algorithm; // HS256, HS384, HS512, RS256, RS384, RS512, ES256, ES384, ES512, PS256, PS384, PS512

  @JacksonXmlProperty(localName = "Audience")
  private ValueRef<String> audience;

  @JacksonXmlProperty(localName = "AdditionalClaims")
  private AdditionalClaims additionalClaims;

  @JacksonXmlElementWrapper(localName = "AdditionalHeaders")
  @JacksonXmlProperty(localName = "Claim")
  private List<Claim> additionalHeaders;

  @JacksonXmlProperty(localName = "CriticalHeaders")
  private ValueRef<String> criticalHeaders;

  @JacksonXmlProperty(localName = "ExpiresIn")
  private String expiresIn; // must have one of this suffixes: ms, s, m, h, d

  @JacksonXmlProperty(localName = "Id")
  private ValueRef<String> id;

  @JacksonXmlProperty(localName = "IgnoreUnresolvedVariables")
  private Boolean ignoreUnresolvedVariables;

  @JacksonXmlProperty(localName = "Issuer")
  private ValueRef<String> issuer;

  /*
  Valid formats:
  yyyy-MM-dd'T'HH:mm:ss.SSSZ
  EEE, dd MMM yyyy HH:mm:ss zzz
  EEEE, dd-MMM-yy HH:mm:ss zzz
  EEE MMM d HH:mm:ss yyyy
  For relative time must have a valid suffix: s, m, h
  */
  @JacksonXmlProperty(localName = "NotBefore")
  private String notBefore;

  @JacksonXmlProperty(localName = "OutputVariable")
  private String outputVariable;

  @JacksonXmlProperty(localName = "PrivateKey")
  private PrivateKey privateKey; // Use only when the algorithm is one of RS256/RS384/RS512, PS256/PS384/PS512, or ES256/ES384/ES512.

  @JacksonXmlProperty(localName = "SecretKey")
  private SecretKey secretKey; // Use only when the algorithm is one of HS256/HS384/HS512.

  @JacksonXmlProperty(localName = "Subject")
  private ValueRef<String> subject;

  @Override
  public void defaultValues() {
    this.defaultHeader();
    this.ignoreUnresolvedVariables = false;
  }

}
