package com.github.gigiosouza.japigeebundler.apigee.policies.security.jwx;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.github.gigiosouza.japigeebundler.apigee.commons.Ref;
import com.github.gigiosouza.japigeebundler.apigee.commons.ValueRef;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@AllArgsConstructor
@NoArgsConstructor
public class PrivateKey {

  @JacksonXmlProperty(localName = "Id")
  private ValueRef<String> id;

  @JacksonXmlProperty(localName = "Password")
  private Ref password;

  @JacksonXmlProperty(localName = "Value")
  private Ref value; // must have prefix 'private.'

}
