package com.github.gigiosouza.japigeebundler.apigee.policies.security.jwx;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.github.gigiosouza.japigeebundler.apigee.commons.ValueRef;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@AllArgsConstructor
@NoArgsConstructor
public class PublicKey {

  @JacksonXmlProperty(localName = "JWKS")
  private JWKS jwks;

  @JacksonXmlProperty(localName = "Value")
  private ValueRef<String> value;

  @JacksonXmlProperty(localName = "Certificate")
  private ValueRef<String> certificate;

}
