package com.github.gigiosouza.japigeebundler.apigee.policies.security.jwx;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import com.github.gigiosouza.japigeebundler.apigee.policies.Policy;
import com.github.gigiosouza.japigeebundler.apigee.commons.ValueRef;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import lombok.Data;

import java.util.List;

@Data
@JacksonXmlRootElement(localName = "VerifyJWS")
public class VerifyJWSPolicy extends Policy {

  @NotEmpty
  @NotNull
  @JacksonXmlProperty(localName = "Algorithm")
  private String algorithm; // HS256, HS384, HS512, RS256, RS384, RS512, ES256, ES384, ES512, PS256, PS384, PS512

  @JacksonXmlElementWrapper(localName = "AdditionalHeaders")
  @JacksonXmlProperty(localName = "Claim")
  private List<Claim> additionalHeaders;

  @JacksonXmlProperty(localName = "DetachContent")
  private String detachContent;

  @JacksonXmlProperty(localName = "IgnoreCriticalHeaders")
  private Boolean ignoreCriticalHeaders;

  @JacksonXmlProperty(localName = "IgnoreUnresolvedVariables")
  private Boolean ignoreUnresolvedVariables;

  @JacksonXmlProperty(localName = "KnownHeaders")
  private ValueRef<String> knownHeaders;

  @JacksonXmlProperty(localName = "PublicKey")
  private PublicKey publicKey; // Use only when the algorithm is one of RS256/RS384/RS512, PS256/PS384/PS512, or ES256/ES384/ES512.

  @JacksonXmlProperty(localName = "SecretKey")
  private SecretKey secretKey; // Use only when the algorithm is one of HS256, HS384, HS512.

  @JacksonXmlProperty(localName = "Source")
  private String source;

  @Override
  public void defaultValues() {
    this.defaultHeader();
    this.ignoreCriticalHeaders = false;
    this.ignoreUnresolvedVariables = false;
    this.source = "request.header.authorization";
  }

}
