package com.github.gigiosouza.japigeebundler.apigee.policies.security.ldap;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.github.gigiosouza.japigeebundler.apigee.commons.ValueRef;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@AllArgsConstructor
@NoArgsConstructor
public class Authentication {

  @JacksonXmlProperty(localName = "BaseDN")
  private String baseDN;

  @JacksonXmlProperty(localName = "UserName")
  private ValueRef<String> userName;

  @JacksonXmlProperty(localName = "Password")
  private ValueRef<String> password;

  @JacksonXmlProperty(localName = "SearchQuery")
  private String searchQuery;

  @JacksonXmlProperty(localName = "Scope")
  private LDAPScope scope;

}
