package com.github.gigiosouza.japigeebundler.apigee.policies.security.ldap;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import com.github.gigiosouza.japigeebundler.apigee.policies.Policy;
import lombok.Data;

@Data
@JacksonXmlRootElement(localName = "LDAP")
public class LDAPPolicy extends Policy {

  @JacksonXmlProperty(localName = "LdapConnectorClass")
  private String ldapConnectorClass;

  @JacksonXmlProperty(localName = "LdapResource")
  private String ldapResource;

  @JacksonXmlProperty(localName = "Authentication")
  private Authentication authentication;

  @JacksonXmlProperty(localName = "Search")
  private Search search;

  @Override
  public void defaultValues() {
    this.defaultHeader();
  }

}
