package com.github.gigiosouza.japigeebundler.apigee.policies.security.ldap;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

@Data
@AllArgsConstructor
@NoArgsConstructor
public class Search {

  @JacksonXmlProperty(localName = "BaseDN")
  private String baseDN;

  @JacksonXmlProperty(localName = "SearchQuery")
  private String searchQuery;

  @JacksonXmlProperty(localName = "Scope")
  private LDAPScope scope;

  @JacksonXmlElementWrapper(localName = "Attributes")
  @JacksonXmlProperty(localName = "Attribute")
  private List<String> attributes;

}
