package com.github.gigiosouza.japigeebundler.apigee.policies.security.oauth;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import com.github.gigiosouza.japigeebundler.apigee.policies.Policy;
import com.github.gigiosouza.japigeebundler.apigee.commons.ValueRef;
import lombok.Data;

@Data
@JacksonXmlRootElement(localName = "DeleteOAuthV1Info")
public class DeleteOAuthV1InfoPolicy extends Policy {

  @JacksonXmlProperty(localName = "AccessToken")
  private ValueRef<String> accessToken;

  @JacksonXmlProperty(localName = "RequestToken")
  private ValueRef<String> requestToken;

  @JacksonXmlProperty(localName = "Verifier")
  private ValueRef<String> verifier;

  @Override
  public void defaultValues() {
    this.defaultHeader();
  }

}
