package com.github.gigiosouza.japigeebundler.apigee.policies.security.oauth;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import com.github.gigiosouza.japigeebundler.apigee.policies.Policy;
import com.github.gigiosouza.japigeebundler.apigee.commons.ValueRef;
import lombok.Data;

@Data
@JacksonXmlRootElement(localName = "DeleteOAuthV2Info")
public class DeleteOAuthV2InfoPolicy extends Policy {

  @JacksonXmlProperty(localName = "AccessToken")
  private ValueRef<String> accessToken;

  @JacksonXmlProperty(localName = "AuthorizationCode")
  private ValueRef<String> authorizationCode;

  @Override
  public void defaultValues() {
    this.defaultHeader();
  }

}
