package com.github.gigiosouza.japigeebundler.apigee.policies.security.oauth;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import com.github.gigiosouza.japigeebundler.apigee.policies.Policy;
import com.github.gigiosouza.japigeebundler.apigee.commons.ValueRef;
import lombok.Data;

@Data
@JacksonXmlRootElement(localName = "GetOAuthV1Info")
public class GetOAuthV1InfoPolicy extends Policy {

  @JacksonXmlProperty(localName = "ConsumerKey")
  private ValueRef<String> consumerKey;

  @JacksonXmlProperty(localName = "RequestToken")
  private ValueRef<String> requestToken;

  @JacksonXmlProperty(localName = "AccessToken")
  private ValueRef<String> accessToken;

  @Override
  public void defaultValues() {
    this.defaultHeader();
  }

}
