package com.github.gigiosouza.japigeebundler.apigee.policies.security.oauth;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import com.github.gigiosouza.japigeebundler.apigee.policies.Policy;
import com.github.gigiosouza.japigeebundler.apigee.commons.ValueRef;
import lombok.Data;

@Data
@JacksonXmlRootElement(localName = "GetOAuthV2Info")
public class GetOAuthV2InfoPolicy extends Policy {

  @JacksonXmlProperty(localName = "AccessToken")
  private ValueRef<String> accessToken;

  @JacksonXmlProperty(localName = "AuthorizationCode")
  private ValueRef<String> authorizationCode;

  @JacksonXmlProperty(localName = "ClientId")
  private ValueRef<String> clientId;

  @JacksonXmlProperty(localName = "IgnoreAccessTokenStatus")
  private Boolean ignoreAccessTokenStatus;

  @JacksonXmlProperty(localName = "RefreshToken")
  private ValueRef<String> refreshToken;

  @Override
  public void defaultValues() {
    this.defaultHeader();
    this.ignoreAccessTokenStatus = false;
    this.accessToken = new ValueRef<>(null, "request.formparam.access_token");
    this.authorizationCode = new ValueRef<>(null, "request.formparam.access_token");
    this.clientId = new ValueRef<>(null, "request.formparam.access_token");
    this.refreshToken = new ValueRef<>(null, "request.formparam.access_token");
  }

}
