package com.github.gigiosouza.japigeebundler.apigee.policies.security.oauth;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import com.github.gigiosouza.japigeebundler.apigee.policies.Policy;
import com.github.gigiosouza.japigeebundler.apigee.commons.ValueRef;
import lombok.Data;

import java.util.Arrays;
import java.util.List;

@Data
@JacksonXmlRootElement(localName = "OAuthV2")
public class OAuthV2Policy extends Policy {

  @JacksonXmlProperty(localName = "AccessToken")
  private String accessToken;

  @JacksonXmlProperty(localName = "AccessTokenPrefix")
  private String accessTokenPrefix;

  @JacksonXmlProperty(localName = "AppEndUser")
  private String appEndUser;

  @JacksonXmlElementWrapper(localName = "Attributes")
  @JacksonXmlProperty(localName = "Attribute")
  private List<Attribute> attributes;

  @JacksonXmlProperty(localName = "ClientId")
  private String clientId;

  @JacksonXmlProperty(localName = "Code")
  private String code;

  @JacksonXmlProperty(localName = "ExpiresIn")
  private ValueRef<String> expiresIn;

  @JacksonXmlProperty(localName = "ExternalAccessToken")
  private String externalAccessToken;

  @JacksonXmlProperty(localName = "ExternalAuthorization")
  private Boolean externalAuthorization;

  @JacksonXmlProperty(localName = "ExternalAuthorizationCode")
  private String externalAuthorizationCode;

  @JacksonXmlProperty(localName = "ExternalRefreshToken")
  private String externalRefreshToken;

  @JacksonXmlProperty(localName = "GenerateResponse")
  private GenerateResponse generateResponse;

  @JacksonXmlProperty(localName = "GenerateErrorResponse")
  private GenerateResponse generateErrorResponse;

  @JacksonXmlProperty(localName = "GrantType")
  private String grantType;

  @JacksonXmlProperty(localName = "Operation")
  private OAuthOperation operation;

  @JacksonXmlProperty(localName = "PassWord")
  private String passWord;

  @JacksonXmlProperty(localName = "RedirectUri")
  private String redirectUri;

  @JacksonXmlProperty(localName = "RefreshToken")
  private String refreshToken;

  @JacksonXmlProperty(localName = "RefreshTokenExpiresIn")
  private ValueRef<String> refreshTokenExpiresIn;

  @JacksonXmlProperty(localName = "ResponseType")
  private String responseType;

  @JacksonXmlProperty(localName = "ReuseRefreshToken")
  private Boolean reuseRefreshToken;

  @JacksonXmlProperty(localName = "Scope")
  private String scope;

  @JacksonXmlProperty(localName = "State")
  private String state;

  @JacksonXmlProperty(localName = "StoreToken")
  private Boolean storeToken;

  @JacksonXmlProperty(localName = "SupportedGrantTypes")
  private SupportedGrantTypes suppertedGrantTypes;

  @JacksonXmlElementWrapper(localName = "Tokens")
  @JacksonXmlProperty(localName = "Token")
  private List<Token> tokens;

  @JacksonXmlProperty(localName = "UserName")
  private String userName;

  @Override
  public void defaultValues() {
    this.defaultHeader();
    this.accessTokenPrefix = "Bearer";
    this.clientId = "request.formparam.client_id";
    this.code = "request.formparam.code";
    this.generateResponse = new GenerateResponse(false);
    this.generateErrorResponse = new GenerateResponse(false);
    this.grantType = "request.formparam.grant_type";
    this.passWord = "request.formparam.password";
    this.redirectUri = "request.formparam.redirect_uri";
    this.refreshToken = "request.formparam.refresh_token";
    this.responseType = "request.formparam.response_type";
    this.reuseRefreshToken = false;
    this.storeToken = false;
    this.suppertedGrantTypes =
      new SupportedGrantTypes(Arrays.asList(OAuthGrantType.authorization_code,
      OAuthGrantType.implicit
    ));
    this.userName = "request.formparam.username";
  }

}
