package com.github.gigiosouza.japigeebundler.apigee.policies.security.oauth;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import com.github.gigiosouza.japigeebundler.apigee.commons.NamedValueRef;
import com.github.gigiosouza.japigeebundler.apigee.policies.Policy;
import com.github.gigiosouza.japigeebundler.apigee.commons.ValueRef;
import lombok.Data;

import java.util.List;

@Data
@JacksonXmlRootElement(localName = "SetOAuthV2Info")
public class SetOAuthV2InfoPolicy extends Policy {

  @JacksonXmlProperty(localName = "AccessToken")
  private ValueRef<String> accessToken;

  @JacksonXmlElementWrapper(localName = "Attributes")
  @JacksonXmlProperty(localName = "Attribute")
  private List<NamedValueRef<String>> attributes;

  @Override
  public void defaultValues() {
    this.defaultHeader();
  }

}
